// linkQueue.java
// demonstruje kolejk zaimplementowan przy uyciu listy dwustronnej
// uruchomienie programu: C>java LinkQueueApp
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;             // dane
   public Link next;              // nastpny element listy
// -------------------------------------------------------------
   public Link(long dd)           // konstruktor
      { dData = dd; }
// -------------------------------------------------------------
   public void displayLink()      // wypisanie klucza elementu
      { System.out.print(dData + " "); }
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class FirstLastList
   {
   private Link first;               // referencja do pierwszego elementu
   private Link last;                // referencja do ostatniego elementu
// -------------------------------------------------------------
   public FirstLastList()            // konstruktor
      {
      first = null;                  // lista nie zawiera jeszcze elementw
      last = null;
      }
// -------------------------------------------------------------
   public boolean isEmpty()          // zwraca true, jeeli lista jest pusta
      { return first==null; }
// -------------------------------------------------------------
   public void insertLast(long dd)   // wstawienie na koniec listy
      {
      Link newLink = new Link(dd);   // tworzymy nowy element
      if( isEmpty() )                // jeeli lista jest pusta...
         first = newLink;            // ...first --> newLink
      else
         last.next = newLink;        // poprzednio ostatni --> newLink
      last = newLink;                // last --> newLink
      }
// -------------------------------------------------------------
   public long deleteFirst()         // usunicie pierwszego elementu
      {                              // (zakadamy, e lista nie jest pusta)
      long temp = first.dData;
      if(first.next == null)         // jeeli tylko jeden element...
         last = null;                // ...last --> null
      first = first.next;            // first --> poprzedni drugi
      return temp;
      }
// -------------------------------------------------------------
   public void displayList()
      {
      Link current = first;          // zaczynamy od pocztku
      while(current != null)         // dopki nie koniec listy...
         {
         current.displayLink();      // ...wypisujemy zawarto elementu...
         current = current.next;     // ...i przechodzimy do nastpnego
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy FirstLastList
////////////////////////////////////////////////////////////////
class LinkQueue
   {
   private FirstLastList theList;
//--------------------------------------------------------------
   public LinkQueue()                // konstruktor
      { theList = new FirstLastList(); }  // tworzymy list dwustronn
//--------------------------------------------------------------
   public boolean isEmpty()          // zwraca true, jeeli kolejka pusta
      { return theList.isEmpty(); }
//--------------------------------------------------------------
   public void insert(long j)        // wstawienie (na koniec kolejki)
      { theList.insertLast(j); }
//--------------------------------------------------------------
   public long remove()              // usunicie (z pocztku kolejki)
      {  return theList.deleteFirst();  }
//--------------------------------------------------------------
   public void displayQueue()
      {
      System.out.print("Kolejka (pocztek-->koniec): ");
      theList.displayList();
      }
//--------------------------------------------------------------
   }  // koniec klasy LinkQueue
////////////////////////////////////////////////////////////////
class LinkQueueApp
   {
   public static void main(String[] args)
      {
      LinkQueue theQueue = new LinkQueue();
      theQueue.insert(20);                 // wstawiamy elementy
      theQueue.insert(40);

      theQueue.displayQueue();             // wypisujemy zawarto kolejki

      theQueue.insert(60);                 // wstawiamy elementy
      theQueue.insert(80);

      theQueue.displayQueue();             // wypisujemy zawarto kolejki

      theQueue.remove();                   // usuwamy elementy
      theQueue.remove();

      theQueue.displayQueue();             // wypisujemy zawarto kolejki
      }  // koniec main()
   }  // koniec klasy LinkQueueApp
////////////////////////////////////////////////////////////////
